﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace RevisionAnalyser.Global
{
    public abstract class Task
    {
        private int _insertOffset = 0;
        private TasksForm _tasksForm;

        public abstract void Run();

        public void SetTasksForm(TasksForm tasksForm)
        {
            _tasksForm = tasksForm;
        }

        public TasksForm GetTaskForm()
        {
            return _tasksForm;
        }

        public void AddLog(string message, Color color)
        {
            if (_tasksForm != null)
            {
                _tasksForm.AddLog(message, color);
            }
            else
            {
                throw new Exception("Tasks form is null.");
            }
        }

        public void UpdateSubProgressValue(int value)
        {
            _tasksForm.UpdateSubProgressValue(value);
        }

        public void EnableSubProgressBar(bool value)
        {
            _tasksForm.EnableSubProgressBar(value);
        }

        protected void InsertTask(Task task)
        {
            if (_tasksForm != null)
            {
                _tasksForm.InsertTask(task, _insertOffset);
            }
            _insertOffset++;
        }

        protected void TaskFinished()
        {
            _tasksForm.NextTask();
        }
    }
}
